// Playground - noun: a place where people can play

import UIKit

//Closure 1
let clos1 = {
    () in
    
    print("Witaj, świecie!")
}

clos1()

//Closure 2
let clos2 = {
    (name: String) -> Void in
    
    print("Witaj, \(name)")
}

clos2("Jon")

func testClosure(handler:(String)->Void) {
    handler("Dasher")
}

testClosure(handler: clos2)

//Closure 3
let clos3 = {
    (name: String) -> String in
    
    return "Witaj, \(name)"
}

print(clos3("Buddy"))

//Closure 4 - Short hand versions of closures
let clos4 = { print("Witaj ze skróconej składni domknięcia")}

clos4()

func testFunction(num: Int, handler:()->Void) {
    for _ in 0 ..< num {
        handler()
    }
}


testFunction(num: 5,handler: {print("Witaj ze skróconej składni domknięcia")})
testFunction(num: 5) {
    print("Witaj ze skróconej składni domknięcia")
}

func testFunction2(num: Int, handler:(_ : String)->Void) {
    for _ in 0..<num {
        handler("mnie")
    }
}


testFunction2(num: 5){
    print("Witaj,\($0)")
}



//Closure 5
let clos5: (String, String) ->Void = {
    print("\($0) \($1)")
}


clos5("Witaj,","Kara")

let clos6: () -> () = {
    print("Cześć")
}

clos6()




// Funkcja wewnętrzna.
func counterFunc() ->(Int) ->() {
    var counter = 0
    func innerFunc(num: Int) {
        counter += num
        print("Razem: \(counter)")
    }
    return innerFunc
}

var counter = counterFunc()
counter(4)
counter(6)
counter(8)


